import _extends from "@babel/runtime/helpers/esm/extends";
export class Store {
  static create(state) {
    return new Store(state);
  }
  constructor(state) {
    this.state = void 0;
    this.listeners = void 0;
    this.subscribe = fn => {
      this.listeners.add(fn);
      return () => {
        this.listeners.delete(fn);
      };
    };
    this.getSnapshot = () => {
      return this.state;
    };
    this.update = newState => {
      if (this.state !== newState) {
        this.state = newState;
        this.listeners.forEach(l => l(newState));
      }
    };
    this.state = state;
    this.listeners = new Set();
  }
  apply(changes) {
    for (const key in changes) {
      if (!Object.is(this.state[key], changes[key])) {
        this.update(_extends({}, this.state, changes));
        return;
      }
    }
  }
  set(key, value) {
    if (!Object.is(this.state[key], value)) {
      this.update(_extends({}, this.state, {
        [key]: value
      }));
    }
  }
}